VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "Comdlg32.ocx"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "COMCTL32.OCX"
Begin VB.Form frmRockmagRoutine 
   Caption         =   "Set Rock Mag Routine"
   ClientHeight    =   8655
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   9600
   Icon            =   "frmRockmagRoutine.frx":0000
   LinkTopic       =   "Form1"
   MDIChild        =   -1  'True
   ScaleHeight     =   8655
   ScaleWidth      =   9600
   Begin MSComDlg.CommonDialog dlgCommonDialog 
      Left            =   0
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame frmPresets 
      Caption         =   "Presets"
      Height          =   3255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   9255
      Begin VB.CommandButton cmdHawaiianStd 
         Caption         =   "Hawaiian Standard AF (25, 50, 100, 200, 400, 800)"
         Height          =   372
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   3855
      End
      Begin VB.CommandButton cmdRockmagEverything 
         Caption         =   "Rockmag ""the Works"""
         Height          =   372
         Left            =   120
         TabIndex        =   2
         Top             =   720
         Width           =   3855
      End
      Begin VB.CheckBox chkRMAllNRM 
         Caption         =   "Measure and AF demagnetize NRM"
         Height          =   255
         Left            =   240
         TabIndex        =   3
         Top             =   1200
         Width           =   2895
      End
      Begin VB.CheckBox chkRMAllNRM3AxisAF 
         Caption         =   "along all three axes"
         Enabled         =   0   'False
         Height          =   255
         Left            =   3360
         TabIndex        =   4
         Top             =   1200
         Width           =   2655
      End
      Begin VB.CheckBox chkRMAllWithRRM 
         Caption         =   "RRM (rps):"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   1560
         Width           =   1215
      End
      Begin VB.TextBox txtRMAllRRMrpsStep 
         Height          =   288
         Left            =   2280
         TabIndex        =   6
         Top             =   1560
         Width           =   732
      End
      Begin VB.TextBox txtRMAllRRMrpsMax 
         Height          =   288
         Left            =   3360
         TabIndex        =   7
         Top             =   1560
         Width           =   732
      End
      Begin VB.TextBox txtRMAllRRMAFField 
         Height          =   288
         Left            =   4680
         TabIndex        =   8
         Top             =   1560
         Width           =   732
      End
      Begin VB.CheckBox chkRMAllRRMdoNegative 
         Caption         =   "and negative rotations"
         Height          =   255
         Left            =   5640
         TabIndex        =   9
         Top             =   1560
         Width           =   2295
      End
      Begin VB.CheckBox chkRMAllARM 
         Caption         =   "ARM Step Size (G):"
         Height          =   255
         Left            =   240
         TabIndex        =   10
         Top             =   1920
         Width           =   1935
      End
      Begin VB.TextBox txtRMAllARMStepSize 
         Height          =   288
         Left            =   2280
         TabIndex        =   11
         Top             =   1920
         Width           =   732
      End
      Begin VB.TextBox txtRMAllARMStepMax 
         Height          =   288
         Left            =   3360
         TabIndex        =   12
         Top             =   1920
         Width           =   732
      End
      Begin VB.TextBox txtRMAllAFFieldForARM 
         Height          =   288
         Left            =   4680
         TabIndex        =   13
         Top             =   1920
         Width           =   732
      End
      Begin VB.CheckBox chkRMAllIRM 
         Caption         =   "AF/IRM log step (G):"
         Height          =   375
         Left            =   240
         TabIndex        =   14
         Top             =   2280
         Width           =   1815
      End
      Begin VB.TextBox txtRMAllLogFactor 
         Height          =   288
         Left            =   2280
         TabIndex        =   15
         Top             =   2280
         Width           =   732
      End
      Begin VB.TextBox txtRMAllMinStepSize 
         Height          =   288
         Left            =   4680
         TabIndex        =   16
         Top             =   2280
         Width           =   732
      End
      Begin VB.TextBox txtRMAllAFMax 
         Height          =   288
         Left            =   6480
         TabIndex        =   17
         Top             =   2280
         Width           =   732
      End
      Begin VB.TextBox txtRMAllIRMMax 
         Height          =   288
         Left            =   8280
         TabIndex        =   18
         Top             =   2280
         Width           =   732
      End
      Begin VB.CheckBox chkRMAllBackfieldDemag 
         Caption         =   "DC Demag via backfield IRM"
         Height          =   375
         Left            =   240
         TabIndex        =   19
         Top             =   2640
         Width           =   2415
      End
      Begin VB.Label Label17 
         Caption         =   "to"
         Height          =   255
         Left            =   3120
         TabIndex        =   20
         Top             =   1560
         Width           =   2535
      End
      Begin VB.Label Label18 
         Caption         =   "in AF "
         Height          =   255
         Left            =   4200
         TabIndex        =   21
         Top             =   1560
         Width           =   1095
      End
      Begin VB.Label Label12 
         Caption         =   "to"
         Height          =   255
         Left            =   3120
         TabIndex        =   22
         Top             =   1920
         Width           =   2535
      End
      Begin VB.Label Label15 
         Caption         =   "in AF "
         Height          =   255
         Left            =   4200
         TabIndex        =   23
         Top             =   1920
         Width           =   1095
      End
      Begin VB.Label Label11 
         Caption         =   "Min. step size (G):"
         Height          =   255
         Left            =   3240
         TabIndex        =   24
         Top             =   2280
         Width           =   1335
      End
      Begin VB.Label Label14 
         Caption         =   "AF Max (G):"
         Height          =   255
         Left            =   5520
         TabIndex        =   25
         Top             =   2280
         Width           =   975
      End
      Begin VB.Label Label16 
         Caption         =   "IRM Max (G):"
         Height          =   255
         Left            =   7320
         TabIndex        =   26
         Top             =   2280
         Width           =   975
      End
   End
   Begin VB.Frame frameSetSteps 
      Caption         =   "Set Steps"
      Height          =   2175
      Left            =   120
      TabIndex        =   27
      Top             =   3360
      Width           =   9255
      Begin VB.TextBox txtStepSize 
         Height          =   288
         Left            =   240
         TabIndex        =   28
         Top             =   360
         Width           =   732
      End
      Begin VB.TextBox txtStepMax 
         Height          =   288
         Left            =   2160
         TabIndex        =   29
         Top             =   360
         Width           =   732
      End
      Begin VB.ComboBox cmbStepSeq 
         Height          =   315
         Left            =   3840
         TabIndex        =   30
         Top             =   360
         Width           =   975
      End
      Begin VB.ComboBox cmbStepSeqScale 
         Height          =   315
         Left            =   6360
         MousePointer    =   1  'Arrow
         TabIndex        =   31
         Top             =   360
         Width           =   975
      End
      Begin VB.CommandButton cmdaddStepSeq 
         Caption         =   "Add"
         Height          =   372
         Left            =   7920
         TabIndex        =   32
         Top             =   360
         Width           =   1092
      End
      Begin VB.TextBox txtARMSteps 
         Height          =   288
         Left            =   240
         TabIndex        =   33
         Top             =   840
         Width           =   732
      End
      Begin VB.TextBox txtARMBiasMax 
         Height          =   288
         Left            =   2880
         TabIndex        =   34
         Top             =   840
         Width           =   732
      End
      Begin VB.TextBox txtAFfieldForARM 
         Height          =   288
         Left            =   4920
         TabIndex        =   35
         Top             =   840
         Width           =   732
      End
      Begin VB.ComboBox cmbARMStepSeqScale 
         Height          =   315
         Left            =   6360
         MousePointer    =   1  'Arrow
         TabIndex        =   36
         Top             =   840
         Width           =   975
      End
      Begin VB.CommandButton cmdAddARMStepSeq 
         Caption         =   "Add"
         Height          =   372
         Left            =   7920
         TabIndex        =   37
         Top             =   960
         Width           =   1092
      End
      Begin VB.ComboBox cmbStepType 
         Height          =   315
         Left            =   120
         TabIndex        =   38
         Top             =   1560
         Width           =   1212
      End
      Begin VB.TextBox txtLevel 
         Height          =   288
         Left            =   1440
         TabIndex        =   39
         Top             =   1560
         Width           =   732
      End
      Begin VB.TextBox txtBiasField 
         Height          =   288
         Left            =   2280
         TabIndex        =   40
         Top             =   1560
         Width           =   732
      End
      Begin VB.TextBox txtSpinSpeed 
         Height          =   288
         Left            =   3120
         TabIndex        =   41
         Top             =   1560
         Width           =   732
      End
      Begin VB.TextBox txtHoldTime 
         Height          =   288
         Left            =   3960
         TabIndex        =   42
         Top             =   1560
         Width           =   732
      End
      Begin VB.CheckBox chkMeasure 
         Caption         =   "Measure"
         Height          =   372
         Left            =   4800
         TabIndex        =   43
         Top             =   1560
         Width           =   950
      End
      Begin VB.CheckBox chkSusceptibility 
         Caption         =   "Susceptibility"
         Height          =   372
         Left            =   5760
         TabIndex        =   44
         Top             =   1560
         Width           =   1212
      End
      Begin VB.TextBox txtRemarks 
         Height          =   288
         Left            =   7080
         TabIndex        =   45
         Top             =   1560
         Width           =   732
      End
      Begin VB.CommandButton cmdAdd 
         Caption         =   "Add"
         Height          =   372
         Left            =   7920
         TabIndex        =   46
         Top             =   1560
         Width           =   1092
      End
      Begin VB.CommandButton cmdReplace 
         Caption         =   "Replace"
         Height          =   375
         Left            =   7920
         TabIndex        =   47
         Top             =   1560
         Visible         =   0   'False
         Width           =   1095
      End
      Begin VB.Label Label3 
         Caption         =   "G steps up to"
         Height          =   255
         Left            =   1080
         TabIndex        =   48
         Top             =   360
         Width           =   1335
      End
      Begin VB.Label Label4 
         Caption         =   "G of type"
         Height          =   255
         Left            =   3000
         TabIndex        =   49
         Top             =   360
         Width           =   855
      End
      Begin VB.Label Label8 
         Caption         =   "G ARM bias steps up to"
         Height          =   255
         Left            =   1080
         TabIndex        =   50
         Top             =   840
         Width           =   2535
      End
      Begin VB.Label Label9 
         Caption         =   "G in AF field of"
         Height          =   255
         Left            =   3720
         TabIndex        =   51
         Top             =   840
         Width           =   1095
      End
      Begin VB.Label Label10 
         Caption         =   "G"
         Height          =   255
         Left            =   5760
         TabIndex        =   52
         Top             =   840
         Width           =   255
      End
      Begin VB.Label Label1 
         Caption         =   "Step Type"
         Height          =   255
         Left            =   120
         TabIndex        =   53
         Top             =   1320
         Width           =   1095
      End
      Begin VB.Label Label2 
         Caption         =   "Level"
         Height          =   255
         Left            =   1440
         TabIndex        =   54
         Top             =   1320
         Width           =   615
      End
      Begin VB.Label Label5 
         Caption         =   "Bias (G)"
         Height          =   255
         Left            =   2280
         TabIndex        =   55
         Top             =   1320
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "Spin (rps)"
         Height          =   255
         Left            =   3120
         TabIndex        =   56
         Top             =   1320
         Width           =   855
      End
      Begin VB.Label Label7 
         Caption         =   "Hold (s)"
         Height          =   255
         Left            =   3960
         TabIndex        =   57
         Top             =   1320
         Width           =   735
      End
      Begin VB.Label Label13 
         Caption         =   "Remarks"
         Height          =   255
         Left            =   7080
         TabIndex        =   58
         Top             =   1320
         Width           =   735
      End
   End
   Begin ComctlLib.ListView lvwSteps 
      Height          =   2175
      Left            =   120
      TabIndex        =   59
      Top             =   5640
      Width           =   9255
      _ExtentX        =   16325
      _ExtentY        =   3836
      View            =   3
      MultiSelect     =   -1  'True
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327682
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear"
      Height          =   372
      Left            =   480
      TabIndex        =   60
      Top             =   8040
      Width           =   1092
   End
   Begin VB.CommandButton cmdDelete 
      Caption         =   "Delete"
      Height          =   372
      Left            =   1920
      TabIndex        =   61
      Top             =   8040
      Width           =   1092
   End
   Begin VB.CommandButton cmdImport 
      Caption         =   "Import from .RMG"
      Height          =   375
      Left            =   3840
      TabIndex        =   62
      Top             =   8040
      Width           =   1695
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save to .RMG"
      Height          =   375
      Left            =   6240
      TabIndex        =   63
      Top             =   8040
      Width           =   1215
   End
   Begin VB.CommandButton cmdOk 
      Caption         =   "OK"
      Height          =   375
      Left            =   8160
      TabIndex        =   64
      Top             =   8040
      Width           =   1215
   End
End
Attribute VB_Name = "frmRockmagRoutine"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim ActiveSAMFile As Integer
Dim SequenceReady As Boolean
Public rmStepList As RockmagSteps
Private rmStepNumber As Integer

Private Sub chkRMAllNRM_Click()
    If chkRMAllNRM = Checked Then
        chkRMAllNRM3AxisAF.Enabled = True
    Else
        chkRMAllNRM3AxisAF.Enabled = False
    End If
End Sub

Private Sub cmdRockmagEverything_Click()
    Dim stepsize As Double
    Dim stepsizeAF As Double
    Dim stepmax As Long
    Dim stepmaxAF As Long
    Dim stepmaxIRM As Long
    Dim minStepSize As Long
    Dim lastStep As Long
    Dim curstep As Long
    Dim numsteps As Double
    Dim field As Long
    Dim i As Double
    'Set rmStepList = Nothing
    'Set rmStepList = New RockmagSteps
    stepsizeAF = val(txtRMAllLogFactor)
    stepmaxAF = val(txtRMAllAFMax)
    If stepmaxAF > AfAxialMax Then stepmaxAF = AfAxialMax
    stepmaxIRM = val(txtRMAllIRMMax)
    minStepSize = val(txtRMAllMinStepSize)
    If stepsizeAF = 0 Or stepsizeAF = 1 Or stepsizeAF > stepmaxAF Or stepsizeAF > stepmaxIRM Then Exit Sub
    If chkRMAllNRM Then
            rmStepList.Add "NRM", MeasureSusceptibility:=EnableSusceptibility
            If chkRMAllNRM3AxisAF = Unchecked Then
                If stepmaxAF > AfAxialMax Then stepmaxAF = AfAxialMax
                numsteps = Log(stepmaxAF) / Log(stepsizeAF)
                If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
                lastStep = 0
                For i = 1 To numsteps
                    curstep = Int(stepsizeAF ^ i)
                    If curstep > AfAxialMax Then curstep = AfAxialMax
                    If ((curstep = 0) Or (curstep > AfAxialMin)) And (curstep - lastStep >= minStepSize) Then
                        rmStepList.Add "AFz", curstep
                        lastStep = curstep
                    End If
                Next
            Else
                stepmax = stepmaxAF
                If (stepmax > AfAxialMax) Or (stepmax > AfTransMax) Then
                    If AfTransMax > AfAxialMax Then stepmax = AfAxialMax Else stepmax = AfTransMax
                End If
                numsteps = Log(stepmax) / Log(stepsizeAF)
                If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
                lastStep = 0
                For i = 1 To numsteps
                    curstep = Int(stepsizeAF ^ i)
                    If (curstep > AfAxialMax) Or (curstep > AfTransMax) Then
                        If AfTransMax > AfAxialMax Then curstep = AfAxialMax Else curstep = AfTransMax
                    End If
                    If ((curstep = 0) Or ((curstep > AfAxialMin) And (curstep > AfTransMin))) And (curstep - lastStep >= minStepSize) Then
                        rmStepList.Add "AF", curstep
                        lastStep = curstep
                    End If
                Next i
            End If
        End If
    ' Rotational remanence magnetization acquisition & AF
    If chkRMAllWithRRM = vbChecked Then
        rmStepList.Add "AFmax", AfAxialMax
        stepsize = val(txtRMAllRRMrpsStep)
        stepmax = val(txtRMAllRRMrpsMax)
        field = val(txtRMAllRRMAFField)
        If stepsize = 0 Or stepsize > stepmax Then Exit Sub
        For i = 0 To stepmax Step stepsize
            rmStepList.Add "RRM", field, 0, i, 5
        Next i
        If chkRMAllRRMdoNegative = vbChecked Then
            rmStepList.Add "AFmax", AfAxialMax
            For i = 0 To -stepmax Step -stepsize
                rmStepList.Add "RRM", field, 0, i, 5
            Next i
        End If
        numsteps = Log(stepmaxAF) / Log(stepsizeAF)
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        lastStep = 0
        For i = 1 To numsteps
            curstep = Int(stepsizeAF ^ i)
            If curstep > AfAxialMax Then curstep = AfAxialMax
            If ((curstep = 0) Or (curstep > AfAxialMin)) And (curstep - lastStep >= minStepSize) Then
                rmStepList.Add "AFz", curstep
                lastStep = curstep
            End If
        Next i
    End If
    ' ARM acquisition & AF demag
    If chkRMAllARM And EnableIRM And EnableARM Then
        rmStepList.Add "AFmax", AfAxialMax
        stepsize = val(txtRMAllARMStepSize)
        stepmax = val(txtRMAllARMStepMax)
        field = val(txtRMAllAFFieldForARM)
        If field > 0.75 * AfAxialMax Then field = 0.75 * AfAxialMax
        If stepsize = 0 Then Exit Sub
        On Error GoTo continuance
        If stepmax Mod stepsize <> 0 Then stepmax = stepmax - stepmax Mod stepsize
continuance:
        On Error GoTo 0
        For i = 0 To stepmax Step stepsize
            rmStepList.Add "ARM", field, i
        Next i
        numsteps = (Log(stepmaxAF) / Log(stepsizeAF))
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        lastStep = 0
        For i = 1 To numsteps
            curstep = Int(stepsizeAF ^ i)
            If curstep > AfAxialMax Then curstep = AfAxialMax
            If ((curstep = 0) Or (curstep > AfAxialMin)) And (curstep - lastStep >= minStepSize) Then
                rmStepList.Add "AFz", curstep
                lastStep = curstep
            End If
        Next i
     ' IRM pulse and AF demag
        rmStepList.Add "AFmax", AfAxialMax
        rmStepList.Add "IRM", 0
        rmStepList.Add "AFmax", AfAxialMax
        rmStepList.Add "IRM", field
        lastStep = 0
        For i = 1 To numsteps
            curstep = Int(stepsizeAF ^ i)
            If curstep > AfAxialMax Then curstep = AfAxialMax
            If ((curstep = 0) Or (curstep > AfAxialMin)) And (curstep - lastStep >= minStepSize) Then
                rmStepList.Add "AFz", curstep
                lastStep = curstep
            End If
        Next i
    End If
     ' IRM stepwise and final cleaning
    If chkRMAllIRM And EnableIRM Then
        rmStepList.Add "AFmax", AfAxialMax
        rmStepList.Add "IRM", 0, MeasureSusceptibility:=EnableSusceptibility
        rmStepList.Add "AFmax", AfAxialMax
        numsteps = (Log(val(txtRMAllIRMMax)) / Log(stepsizeAF))
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        lastStep = 0
        For i = 1 To numsteps
            curstep = Int(stepsizeAF ^ i)
            If curstep > PulseLFMax Then
                If EnableIRMHi Then
                    If curstep > PulseHFMax Then curstep = PulseHFMax
                Else
                    curstep = PulseLFMax
                End If
            End If
            If ((curstep = 0) Or (curstep > PulseLFMin)) And (curstep - lastStep >= minStepSize) Then
                rmStepList.Add "IRM", curstep
                lastStep = curstep
            End If
        Next i
        numsteps = Log(stepmaxAF) / Log(stepsizeAF)
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        lastStep = 0
        For i = 1 To numsteps
            curstep = Int(stepsizeAF ^ i)
            If curstep > AfAxialMax Then curstep = AfAxialMax
            If ((curstep = 0) Or (curstep > AfAxialMin)) And (curstep - lastStep >= minStepSize) Then
                rmStepList.Add "AFz", curstep
                lastStep = curstep
            End If
        Next i
        rmStepList.Add "AFmax", AfAxialMax
    End If
     ' IRM backfield DC demag
    If chkRMAllBackfieldDemag And EnableIRMBackfield Then
        numsteps = (Log(val(txtRMAllIRMMax)) / Log(stepsizeAF))
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        curstep = Int(stepsizeAF ^ numsteps)
        If curstep > PulseLFMax Then
            If EnableIRMHi Then
                If curstep > PulseHFMax Then curstep = PulseHFMax
            Else
                curstep = PulseLFMax
            End If
        End If
        If (curstep = 0) Or (curstep > PulseLFMin) Then rmStepList.Add "IRM", curstep
       lastStep = curstep
        For i = 1 To numsteps - 1
            curstep = -Int(stepsizeAF ^ i)
            If -curstep > PulseLFMax Then curstep = -PulseLFMax
            If ((curstep = 0) Or (-curstep > PulseLFMin)) And (Abs(curstep - lastStep) >= minStepSize) Then
                rmStepList.Add "IRM", curstep
                lastStep = curstep
            End If
        Next i
        rmStepList.Add "AFmax", AfAxialMax
    End If
     refreshListDisplay
End Sub

Private Sub form_resize()
    Me.Height = 9060
    Me.Width = 9690
End Sub

Public Sub refreshListDisplay()
    Dim i As Integer
    Dim curItem As ListItem
    lvwSteps.ListItems.Clear
    With rmStepList
        If .Count = 0 Then Exit Sub
        For i = 1 To .Count
            With .Item(i)
                Set curItem = lvwSteps.ListItems.Add(i, .key)
                curItem.Text = i
                curItem.SubItems(1) = .StepType
                curItem.SubItems(2) = .level
                curItem.SubItems(3) = .BiasField
                curItem.SubItems(4) = .SpinSpeed
                curItem.SubItems(5) = .HoldTime
                If .Measure Then curItem.SubItems(6) = "Y" Else curItem.SubItems(6) = "N"
                If .MeasureSusceptibility Then curItem.SubItems(7) = "Y" Else curItem.SubItems(7) = "N"
                curItem.SubItems(8) = .Remarks ' (November 2007 L Carporzen) Remarks column in RMG
            End With
        Next i
    End With
End Sub

Private Sub Form_Load()
    Dim colX As ColumnHeader ' Declare variable.
    If FileExists(Prog_IcoFile) And LenB(Prog_IcoFile) > 0 Then frmRockmagRoutine.Icon = LoadPicture(Prog_IcoFile) ' (October 2007 L Carporzen)
    SequenceReady = False
    Set rmStepList = New RockmagSteps
    Set colX = lvwSteps.ColumnHeaders.Add(1)
    colX.Text = "#"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(2)
    colX.Text = "Step Type"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(3)
    colX.Text = "Level (G)"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(4)
    colX.Text = "Bias Field (G)"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(5)
    colX.Text = "Spin (RPS)"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(6)
    colX.Text = "Hold (sec)"
    colX.Width = Me.TextWidth(colX.Text & " ")
    Set colX = lvwSteps.ColumnHeaders.Add(7)
    colX.Text = "Measure?"
    colX.Width = Me.TextWidth(colX.Text)
    Set colX = lvwSteps.ColumnHeaders.Add(8)
    colX.Text = "Suscep?"
    colX.Width = Me.TextWidth(colX.Text)
    Set colX = lvwSteps.ColumnHeaders.Add(9) ' (November 2007 L Carporzen) Remarks column in RMG
    colX.Text = "Remarks"
    colX.Width = Me.TextWidth(colX.Text)
    cmbStepType.Clear
    cmbStepType.AddItem "AF"
    cmbStepType.AddItem "AFz"
    cmbStepType.AddItem "AFmax"
    cmbStepType.AddItem "UAF"
    cmbStepType.AddItem "ARM"
    cmbStepType.AddItem "IRM"
    cmbStepType.AddItem "NRM"
    cmbStepType.AddItem "RRM"
    cmbStepType.AddItem "RRMz"
    cmbStepSeq.Clear
    cmbStepSeq.AddItem "AF"
    cmbStepSeq.AddItem "AFz"
    cmbStepSeq.AddItem "IRM"
    cmbStepSeq.ListIndex = 0
    cmbStepSeqScale.Clear
    cmbStepSeqScale.AddItem "Linear"
    cmbStepSeqScale.AddItem "Log"
    cmbStepSeqScale.ListIndex = 0
    cmbARMStepSeqScale.Clear
    cmbARMStepSeqScale.AddItem "Linear"
    cmbARMStepSeqScale.AddItem "Log"
    cmbARMStepSeqScale.ListIndex = 0
    chkMeasure.value = Checked
    loadDefaults
End Sub

Private Sub lvwSteps_MouseDown(Button As Integer, _
      Shift As Integer, X As Single, Y As Single)
' (September 2007 L Carporzen) RockMag lines editable by a right click
   If rmStepList.Count = 0 Then Exit Sub
   If Button = vbRightButton And Not lvwSteps.SelectedItem.Index = 0 Then
    rmStepNumber = lvwSteps.SelectedItem.Index
    With rmStepList.Item(rmStepNumber)
        cmbStepType = .StepType
        txtLevel = .level
        txtBiasField = .BiasField
        txtSpinSpeed = .SpinSpeed
        txtHoldTime = .HoldTime
        If .Measure Then chkMeasure.value = Checked Else chkMeasure.value = Unchecked
        If .MeasureSusceptibility Then chksusceptibility.value = Checked Else chksusceptibility.value = Unchecked
        txtRemarks = .Remarks ' (November 2007 L Carporzen) Remarks column in RMG
    End With
    cmdReplace.Visible = True ' Replace the button "Add" by a "Replace" one
    MsgBox "You can edit the parameters of the line " & rmStepNumber & ". Click on replace when done."
   End If
End Sub

Private Sub cmdReplace_Click()
' (September 2007 L Carporzen) Actualize the line in the RockMag list
    With rmStepList.Item(rmStepNumber)
      .StepType = cmbStepType.Text
      If cmbStepType.Text = "NRM" Then
        .level = 0
        .BiasField = 0
        .SpinSpeed = 0
        .HoldTime = 0
      Else
        .level = val(txtLevel)
        .BiasField = val(txtBiasField)
        .SpinSpeed = val(txtSpinSpeed)
        .HoldTime = val(txtHoldTime)
      End If
      If chkMeasure.value = Checked Then .Measure = True Else .Measure = False
      If chksusceptibility.value = Checked Then .MeasureSusceptibility = True Else .MeasureSusceptibility = False
      .Remarks = txtRemarks ' (November 2007 L Carporzen) Remarks column in RMG
    End With
    refreshListDisplay
    cmdReplace.Visible = False  ' Put back the button "Add"
End Sub

Private Sub cmdaddStepSeq_Click()
    Dim stepsize As Double
    Dim stepmax As Double
    Dim numsteps As Integer
    Dim curItem As ListItem
    Dim curstep As Double
    Dim i As Double
    stepsize = val(txtStepSize)
    stepmax = val(txtStepMax)
    If stepsize = 0 Or stepsize > stepmax Then Exit Sub
    If cmbStepSeqScale = "Log" Then
        rmStepList.Add cmbStepSeq.Text, 0, val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
        If stepsize = 1 Then Exit Sub
        numsteps = Log(stepmax) / Log(stepsize)
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)
        For i = 1 To numsteps
            curstep = Int(stepsize ^ i)
            rmStepList.Add cmbStepSeq.Text, curstep, val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
        Next i
    Else
        If stepmax Mod stepsize <> 0 Then stepmax = stepmax - stepmax Mod stepsize
        rmStepList.Add cmbStepSeq.Text, 0, val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
        For i = stepsize To stepmax Step stepsize
            rmStepList.Add cmbStepSeq.Text, Int(i), val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
        Next i
    End If
    refreshListDisplay
End Sub

Private Sub cmdaddARMStepSeq_Click()
    Dim stepsize As Double
    Dim stepmax As Double
    Dim numsteps As Integer
    Dim curItem As ListItem
    Dim i As Double
    stepsize = val(txtARMSteps)
    stepmax = val(txtARMBiasMax)
    If stepsize = 0 Or stepsize > stepmax Then Exit Sub
    If cmbStepSeqScale = "Log" Then
        rmStepList.Add cmbStepSeq.Text, 0
        If stepsize = 1 Then Exit Sub
        numsteps = Log(stepmax) / Log(stepsize)
        If numsteps - Int(numsteps) > 0.5 Then numsteps = Int(numsteps) + 1 Else numsteps = Int(numsteps)

        For i = 1 To Log(stepmax) / Log(stepsize)
            rmStepList.Add cmbStepSeq.Text, val(txtAFfieldForARM), stepsize ^ i
        Next i
    Else
        If stepmax Mod stepsize <> 0 Then stepmax = stepmax - stepmax Mod stepsize
        For i = 0 To stepmax Step stepsize
            rmStepList.Add "ARM", val(txtAFfieldForARM), i
        Next i
    End If
    refreshListDisplay
End Sub

Private Sub cmdAdd_Click()
    Dim i As Double
    If cmbStepType.Text = "NRM" Then ' (August 2007 L Carporzen) NRM possible in RockMag
    rmStepList.Add cmbStepType.Text, 0, 0, 0, _
        0, (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
    Else
    If cmbStepType.Text = "UAF" Then ' (March 2008 L Carporzen) Uniaxial AF: measure the sample after each axis demag
    cmbStepType.Text = "UAFX1"
    rmStepList.Add cmbStepType.Text, val(txtLevel), val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
    cmbStepType.Text = "UAFX2"
    rmStepList.Add cmbStepType.Text, val(txtLevel), val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
    cmbStepType.Text = "UAFZ"
    rmStepList.Add cmbStepType.Text, val(txtLevel), val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
    cmbStepType.Text = "UAF"
    Else
    rmStepList.Add cmbStepType.Text, val(txtLevel), val(txtBiasField), val(txtSpinSpeed), _
        val(txtHoldTime), (chkMeasure.value = Checked), (chksusceptibility.value = Checked), txtRemarks
    End If
    End If
    refreshListDisplay
End Sub

Private Sub cmdDelete_Click()
    Dim targetItem As ListItem
    If lvwSteps.SelectedItem.Index > 0 Then
        For Each targetItem In lvwSteps.ListItems
            If targetItem.Selected Then
                rmStepList.Remove targetItem.key
            End If
        Next targetItem
    Else
        cmdDelete.Enabled = False
    End If
    refreshListDisplay
End Sub

Private Sub cmdClear_Click()
    Set rmStepList = Nothing
    Set rmStepList = New RockmagSteps
    refreshListDisplay
End Sub

Private Sub cmdOk_Click()
    SequenceReady = True
    saveDefaults
    Me.Hide
End Sub

Private Sub cmdHawaiianStd_Click()
    Dim i As Integer
    Set rmStepList = Nothing
    Set rmStepList = New RockmagSteps
    rmStepList.Add "AF", 0
    For i = 1 To 6
        rmStepList.Add "AF", 25 * 2 ^ i
    Next i
    refreshListDisplay
End Sub

Private Sub saveDefaults()
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllNRM", Str(chkRMAllNRM.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllNRM3AxisAF", Str(chkRMAllNRM3AxisAF.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllWithRRM", Str(chkRMAllWithRRM.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllRRMdoNegative", Str(chkRMAllRRMdoNegative.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllARM", Str(chkRMAllARM.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllIRM", Str(chkRMAllIRM.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllBackfieldDemag", Str(chkRMAllBackfieldDemag.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkMeasure", Str(chkMeasure.value)
    Config_SaveSetting "RockmagRoutineDefaults", "chkRMAllRRMdoNegative", Str(chkRMAllRRMdoNegative.value)
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllRRMrpsStep", txtRMAllRRMrpsStep.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllRRMrpsMax", txtRMAllRRMrpsMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllRRMAFField", txtRMAllRRMAFField.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllARMStepSize", txtRMAllARMStepSize.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllARMStepMax", txtRMAllARMStepMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllAFFieldForARM", txtRMAllAFFieldForARM.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllLogFactor", txtRMAllLogFactor.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllMinStepSize", txtRMAllMinStepSize.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllAFMax", txtRMAllAFMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtRMAllIRMMax", txtRMAllIRMMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtStepSize", txtStepSize.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtStepMax", txtStepMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtARMSteps", txtARMSteps.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtARMBiasMax", txtARMBiasMax.Text
    Config_SaveSetting "RockmagRoutineDefaults", "txtAFfieldForARM", txtAFfieldForARM.Text
    Config_SaveSetting "RockmagRoutineDefaults", "cmbStepSeq", cmbStepSeq.Text
    Config_SaveSetting "RockmagRoutineDefaults", "cmbStepSeqScale", cmbStepSeqScale.Text
    Config_SaveSetting "RockmagRoutineDefaults", "cmbARMStepSeqScale", cmbARMStepSeqScale.Text
    Config_SaveSetting "RockmagRoutineDefaults", "cmbStepType", cmbStepType.Text
End Sub

Private Sub loadDefaults()
    chkRMAllNRM.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllNRM", "0", Prog_INIFile))
    chkRMAllNRM3AxisAF.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllNRM3AxisAF", "0", Prog_INIFile))
    chkRMAllWithRRM.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllWithRRM", "0", Prog_INIFile))
    chkRMAllRRMdoNegative.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllRRMdoNegative", "0", Prog_INIFile))
    chkRMAllARM.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllARM", "0", Prog_INIFile))
    chkRMAllIRM.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllIRM", "0", Prog_INIFile))
    chkRMAllBackfieldDemag.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkRMAllBackfieldDemag", "0", Prog_INIFile))
    chkMeasure.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkMeasure", "1", Prog_INIFile))
    chksusceptibility.value = val(Config_GetFromINI("RockmagRoutineDefaults", "chkSusceptibility", "0", Prog_INIFile))
    txtRMAllRRMrpsStep.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllRRMrpsStep", vbNullString, Prog_INIFile)
    txtRMAllRRMrpsMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllRRMrpsMax", vbNullString, Prog_INIFile)
    txtRMAllRRMAFField.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllRRMAFField", vbNullString, Prog_INIFile)
    txtRMAllARMStepSize.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllARMStepSize", vbNullString, Prog_INIFile)
    txtRMAllARMStepMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllARMStepMax", vbNullString, Prog_INIFile)
    txtRMAllAFFieldForARM.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllAFFieldForARM", vbNullString, Prog_INIFile)
    txtRMAllLogFactor.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllLogFactor", vbNullString, Prog_INIFile)
    txtRMAllMinStepSize.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllMinStepSize", vbNullString, Prog_INIFile)
    txtRMAllAFMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllAFMax", vbNullString, Prog_INIFile)
    txtRMAllIRMMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtRMAllIRMMax", vbNullString, Prog_INIFile)
    txtStepSize.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtStepSize", vbNullString, Prog_INIFile)
    txtStepMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtStepMax", vbNullString, Prog_INIFile)
    txtARMSteps.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtARMSteps", vbNullString, Prog_INIFile)
    txtARMBiasMax.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtARMBiasMax", vbNullString, Prog_INIFile)
    txtAFfieldForARM.Text = Config_GetFromINI("RockmagRoutineDefaults", "txtAFfieldForARM", vbNullString, Prog_INIFile)
    cmbStepSeq.Text = Config_GetFromINI("RockmagRoutineDefaults", "cmbStepSeq", "AF", Prog_INIFile)
    cmbStepSeqScale.Text = Config_GetFromINI("RockmagRoutineDefaults", "cmbStepSeqScale", "Log", Prog_INIFile)
    cmbARMStepSeqScale.Text = Config_GetFromINI("RockmagRoutineDefaults", "cmbARMStepSeqScale", "Linear", Prog_INIFile)
    cmbStepType.Text = Config_GetFromINI("RockmagRoutineDefaults", "cmbStepType", "AF", Prog_INIFile)
End Sub

Private Sub cmdImport_Click()
    Dim sfilen  As String           ' Path + filename of selected file
    Dim dirname As String           ' Path of selected file
    Dim fname   As String           ' Filename of selected file
    Dim ind     As Variant          ' index of first character of filename
    ' Initialize the dialog box for Sample File Open
    dlgCommonDialog.FILTER = "Rockmag file (*.rmg)|*.rmg|All files (*.*)|*.*"
    dlgCommonDialog.Flags = cdlOFNFileMustExist
    dlgCommonDialog.DialogTitle = "Open RMG File..."
    If FileExists(Prog_DefaultPath) Then
            dlgCommonDialog.InitDir = Prog_DefaultPath
        Else
            dlgCommonDialog.InitDir = "\"
        End If
    dlgCommonDialog.ShowOpen
    ' ----- Start parsing the filename -----
    ' Parse the file name
    sfilen = dlgCommonDialog.filename
    If LenB(sfilen) = 0 Then Exit Sub          ' If we don't have a filename
                                               ' then don't processs it.
    ImportRMGRoutine (sfilen)
ErrHandler:
    'User pressed the Cancel button
    Exit Sub
End Sub

Private Sub ImportRMGRoutine(ByVal filen As String)
    Dim filenum As Integer
    Dim whole_file As String
    Dim lines As Variant
    Dim the_array As Variant
    Dim num_rows As Long
    Dim R As Long
    Dim readStepType As String
    Dim readStepLevel As Double
    Dim readBias As Double
    Dim readSpin As Double
    Dim readHold As Double
    Dim readMeas As Double
    Dim readSusceptibility As Double
    filenum = FreeFile
    Open filen For Input As #filenum
    whole_file = Input$(LOF(filenum), #filenum)
    Close #filenum
    lines = Split(whole_file, vbCrLf)
    num_rows = UBound(lines)
    ReDim the_array(num_rows)
    For R = 0 To num_rows
        the_array(R) = Split(lines(R), ",")
    Next R
    For R = 0 To UBound(the_array) - 1
        If UBound(the_array(R)) > 9 Then
            If val(the_array(R)(5)) <> 0 Then
                readStepType = the_array(R)(0)
                readStepLevel = val(the_array(R)(1))
                readBias = val(the_array(R)(2))
                readSpin = val(the_array(R)(3))
                readHold = val(the_array(R)(4))
                readMeas = val(the_array(R)(5))
                readSusceptibility = val(the_array(R)(8))
                rmStepList.Add readStepType, readStepLevel, readBias, readSpin, readHold, (readMeas <> 0), (readSusceptibility <> 0)
            End If
        End If
    Next R
    refreshListDisplay
End Sub

Private Sub cmdSave_Click()
    Dim sfilen  As String           ' Path + filename of selected file
    ' Initialize the dialog box for Save
    dlgCommonDialog.FILTER = "Rockmag file (*.rmg)|*.rmg|All files (*.*)|*.*"
    dlgCommonDialog.DialogTitle = "Save to RMG File..."
    If FileExists(Prog_DefaultPath) Then
        dlgCommonDialog.InitDir = Prog_DefaultPath
    Else
        dlgCommonDialog.InitDir = "\"
    End If
    dlgCommonDialog.ShowSave
    sfilen = dlgCommonDialog.filename
    If LenB(sfilen) = 0 Then Exit Sub ' If we don't have a filename then don't processs it.
    SaveRMGRoutine (sfilen)
End Sub

Private Sub SaveRMGRoutine(ByVal filen As String)
    Dim filepath As String
    Dim filenum As Integer
    Dim i As Integer
    Dim j As Double
    Dim curItem As ListItem
    filepath = filen
    filenum = FreeFile
    If FileExists(filepath) = True Then
        If MsgBox("Would you like to replace the existing file?", vbYesNo) = vbNo Then Exit Sub
    End If
    ' Create the file new even if it exist
    Open filepath For Output As #filenum
    Print #filenum, "Level"; ",";
    Print #filenum, "Bias Field (G)"; ",";
    Print #filenum, "Spin Speed (rps)"; ",";
    Print #filenum, "Hold Time (s)"; ",";
    Print #filenum, "Mz (emu)"; ",";
    Print #filenum, "Std. Dev. Z"; ",";
    Print #filenum, "Mz/Vol"; ",";
    Print #filenum, "Moment Susceptibility (emu/Oe)"; ",";
    Print #filenum, "Mx (emu)"; ",";
    Print #filenum, "Std. Dev. X"; ",";
    Print #filenum, "My (emu)"; ",";
    Print #filenum, "Std. Dev. Y"; " "
    Close #filenum
    Open filepath For Append As #filenum
    With rmStepList
        If .Count = 0 Then Exit Sub
        For i = 1 To .Count
            With .Item(i)
                Print #filenum, .StepType; ",";
                Print #filenum, .level; ",";
                Print #filenum, .BiasField; ",";
                Print #filenum, .SpinSpeed; ",";
                Print #filenum, .HoldTime; ",";
                j = 1.00000000000001E-09
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ","; ' Measure
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ",";
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ",";
                j = 1.00000000001
                If .MeasureSusceptibility Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ","; ' Susceptibility
                j = 1.00000000000001E-09
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ",";
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ",";
                If .Measure Then Print #filenum, j; ","; Else Print #filenum, " 0 "; ",";
                If .Measure Then Print #filenum, j; Else Print #filenum, " 0 ";
                Print #filenum, " "
            End With
        Next i
    End With
    Close #filenum
End Sub
